IF EXISTS (SELECT * FROM sys.objects WHERE  object_id = OBJECT_ID(N'P_EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS_ANALITICO') AND type IN(N'P', N'PC')
)
	DROP PROCEDURE P_EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS_ANALITICO;
GO

CREATE PROCEDURE P_EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS_ANALITICO (@CD_EMP INT, @CD_FILIAL VARCHAR(MAX), @TIPO_DATA INT, @DT_INICIO DATETIME, @DT_FIM DATETIME)
AS
BEGIN

--@TIPO_DATA
--entrada 0
--saida 1

	SELECT  DISTINCT CD_EMP,
        CD_FILIAL, 
		CD_NF_ENT ,
		NR_NF_ENTRADA, 
		DATA_ENTRADA ,
		TRIM(SUBSTRING(TIPO_ENTRADA, 
                 CHARINDEX('-', TIPO_ENTRADA) + 1, 
                 LEN(TIPO_ENTRADA))) as TIPO_ENTRADA,
		TIPO_DOC,
		CD_NF_SAI ,
		NR_DOC, 
		CD_CX, 
		DATA_SAIDA , 
		CD_PROD,
		DS_PROD , 
		NR_NF_DEV,
		DT_NF_DEV,
		
		QT_IT_ENT , 
		VLR_ICMS_ST_DARE_ENT, 
		VLR_ICMS_EFETIVO_ENT,
		VLR_ICMS_SUBS_ENT,
		VLR_ICMS_RET_ENT,
		VLR_FECOP_ENT,
		VLR_FECOP_RET_ENT,
		VLR_FECOP_ST_ENT,
  
		ISNULL(NOTA_SAI ,0 ) AS NOTA_SAI , ISNULL(QT_IT_SAI ,0 )AS QT_IT_SAI,
		ISNULL(VLR_ICMS_ST_DARE_SAI,0 ) AS VLR_ICMS_ST_DARE_SAI, 
		ISNULL(VLR_ICMS_EFETIVO_SAI,0 ) AS VLR_ICMS_EFETIVO_SAI,
		ISNULL(VLR_ICMS_SUBS_SAI,0 ) AS VLR_ICMS_SUBS_SAI,
		ISNULL(VLR_ICMS_RET_SAI,0 ) AS VLR_ICMS_RET_SAI,
		ISNULL(VLR_FECOP_SAI,0 ) AS VLR_FECOP_SAI,
		ISNULL(VLR_FECOP_RET_SAI,0 ) AS VLR_FECOP_RET_SAI,
		ISNULL(VLR_FECOP_ST_SAI,0 ) AS VLR_FECOP_ST_SAI,

		VLR_ICMS_ST_DARE_ENT -  ISNULL(VLR_ICMS_ST_DARE_SAI ,0) AS VLR_ICMS_DARE_SALDO ,
		VLR_ICMS_EFETIVO_ENT - ISNULL( VLR_ICMS_EFETIVO_SAI,0) AS VLR_ICMS_EFETIVO_SALDO ,  
	    VLR_ICMS_SUBS_ENT - ISNULL( VLR_ICMS_SUBS_SAI,0) AS VLR_ICMS_SUBS_SALDO,   
		VLR_ICMS_RET_ENT - ISNULL( VLR_ICMS_RET_SAI,0) AS VLR_ICMS_RET_SALDO  ,
		VLR_FECOP_ENT   - ISNULL( VLR_FECOP_SAI,0) AS VLR_FECOP_SALDO ,
		VLR_FECOP_RET_ENT - ISNULL( VLR_FECOP_RET_SAI,0) AS VLR_FECOP_RET_SALDO ,
		VLR_FECOP_ST_ENT - ISNULL( VLR_FECOP_ST_SAI,0) AS VLR_FECOP_ST_SALDO
		

FROM (

		SELECT 
		ENT.CD_EMP,
		ENT.CD_FILIAL, 
		ENT.CD_NF AS CD_NF_ENT ,
		ENT.NR_NF AS NR_NF_ENTRADA, 
		ENT.DT_ENT AS DATA_ENTRADA ,
		'NOTA FISCAL ENTRADA' AS TIPO_DOC , 
		CASE WHEN O.TP_MOV = 10 THEN 'ENTRADA TRANSFERNCIA' 
			 WHEN O.TP_MOV = 0 THEN 'ENTRADA COMPRAS'
		ELSE DS.DS_MOV END AS TIPO_ENTRADA ,
		0 AS CD_NF_SAI ,
		0 AS NR_DOC, 
		0 AS CD_CX, 
		'' AS DATA_SAIDA , 
		CRED.CD_PROD,
		P.DS_PROD ,
		0 AS NR_NF_DEV,
		'' AS DT_NF_DEV,
		CRED.QT_IT AS QT_IT_ENT,
		CRED.VLR_ICMS_ST_DARE AS VLR_ICMS_ST_DARE_ENT, 
		CRED.VLR_ICMS_EFETIVO AS  VLR_ICMS_EFETIVO_ENT,
		CRED.VLR_ICMS_SUBS AS VLR_ICMS_SUBS_ENT,
		CRED.VLR_ICMS_RET AS  VLR_ICMS_RET_ENT,
		CRED.VLR_FECOP AS  VLR_FECOP_ENT,
		CRED.VLR_FECOP_RET AS VLR_FECOP_RET_ENT,
		CRED.VLR_FECOP_ST AS VLR_FECOP_ST_ENT,

		0 AS  NOTA_SAI ,
		0 AS QT_IT_SAI ,
		0 AS VLR_ICMS_ST_DARE_SAI,
		0 AS VLR_ICMS_EFETIVO_SAI,
		0 AS VLR_ICMS_SUBS_SAI,
		0 AS VLR_ICMS_RET_SAI, 
		0 AS VLR_FECOP_SAI,
		0 AS VLR_FECOP_RET_SAI,
		0 AS VLR_FECOP_ST_SAI, 

		0 AS PROT_ICMS_ST_SAIDA
		
		FROM EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS CRED
		 INNER JOIN EST_NF_ENT  ENT ON
		 CRED.CD_EMP = ENT.CD_EMP
		AND CRED.CD_FILIAL = ENT.CD_FILIAL
		AND CRED.CD_NF = ENT.CD_NF
		INNER JOIN EST_PROD P ON CRED.CD_EMP = P.CD_EMP 
		AND P.CD_PROD =  CRED.CD_PROD 	
		INNER JOIN GLB_MOV_OP O ON O.CD_MOV_OP = ENT.CD_NT_MOV
		INNER JOIN GLB_MOV_OP_TP_MOV DS ON DS.TP_MOV = O.TP_MOV
		WHERE CRED.CD_EMP  =  1 
		AND NOT EXISTS ( SELECT 1 FROM EST_NF_ENT_ENTRADA_ICMS_ST_MOV MOV_SAI 
						WHERE CRED.CD_EMP = MOV_SAI.CD_EMP
							AND CRED.CD_FILIAL = MOV_SAI.CD_FILIAL
							AND CRED.CD_NF = MOV_SAI.CD_NF_ENT_CRED
							AND CRED.CD_PROD = MOV_SAI.CD_PROD)

		UNION ALL

        SELECT 
		ENT.CD_EMP,
		ENT.CD_FILIAL, 
		ENT.CD_NF AS CD_NF_ENT ,
		ENT.NR_NF AS NR_NF_ENTRADA, 
		ENT.DT_ENT AS DATA_ENTRADA ,
		CASE WHEN ISNULL(MOV_SAI.CD_EMP,0) = 1 THEN 'NOTA FISCAL SAIDA' ELSE '' END AS TIPO_DOC , 
		CASE WHEN O.TP_MOV = 10 THEN 'ENTRADA TRANSFERNCIA' 
			 WHEN O.TP_MOV = 0 THEN 'ENTRADA COMPRAS'
		ELSE DS.DS_MOV END AS TIPO_ENTRADA ,
		ISNULL(SAI.CD_NF,0) AS CD_NF_SAI ,
		ISNULL(SAI.NF_NF,0) AS NR_DOC, 
		0 AS CD_CX, 
		ISNULL(SAI.DT_EMI_NF,'') AS DATA_SAIDA , 
		CRED.CD_PROD,
		P.DS_PROD ,
		0 AS NR_NF_DEV,
		'' AS DT_NF_DEV,
		CRED.QT_IT AS QT_IT_ENT,
		CRED.VLR_ICMS_ST_DARE AS VLR_ICMS_ST_DARE_ENT, 
		CRED.VLR_ICMS_EFETIVO AS  VLR_ICMS_EFETIVO_ENT,
		CRED.VLR_ICMS_SUBS AS VLR_ICMS_SUBS_ENT,
		CRED.VLR_ICMS_RET AS  VLR_ICMS_RET_ENT,
		CRED.VLR_FECOP AS  VLR_FECOP_ENT,
		CRED.VLR_FECOP_RET AS VLR_FECOP_RET_ENT,
		CRED.VLR_FECOP_ST AS VLR_FECOP_ST_ENT,

		SAI.NF_NF AS  NOTA_SAI ,
		MOV_SAI.QT_IT AS QT_IT_SAI ,
		MOV_SAI.VLR_ICMS_ST_DARE * MOV_SAI.QT_IT AS VLR_ICMS_ST_DARE_SAI,
		MOV_SAI.VLR_ICMS_EFETIVO * MOV_SAI.QT_IT AS VLR_ICMS_EFETIVO_SAI,
		MOV_SAI.VLR_ICMS_SUBS * MOV_SAI.QT_IT AS VLR_ICMS_SUBS_SAI,
		MOV_SAI.VLR_ICMS_RET * MOV_SAI.QT_IT AS VLR_ICMS_RET_SAI, 
		MOV_SAI.VLR_FECOP * MOV_SAI.QT_IT AS VLR_FECOP_SAI,
		MOV_SAI.VLR_FECOP_RET * MOV_SAI.QT_IT AS VLR_FECOP_RET_SAI,
		MOV_SAI.VLR_FECOP_ST * MOV_SAI.QT_IT AS VLR_FECOP_ST_SAI, 

		ISNULL(MOV_SAI.PROT_ICMS_ST_SAIDA,0 ) AS PROT_ICMS_ST_SAIDA
		
		FROM EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS CRED
		 INNER JOIN EST_NF_ENT  ENT ON
		 CRED.CD_EMP = ENT.CD_EMP
		AND CRED.CD_FILIAL = ENT.CD_FILIAL
		AND CRED.CD_NF = ENT.CD_NF
		INNER JOIN GLB_MOV_OP O ON O.CD_MOV_OP = ENT.CD_NT_MOV
		INNER JOIN GLB_MOV_OP_TP_MOV DS ON DS.TP_MOV = O.TP_MOV
		INNER JOIN EST_PROD P ON CRED.CD_EMP = P.CD_EMP 
		AND P.CD_PROD =  CRED.CD_PROD 

		INNER JOIN EST_NF_ENT_ENTRADA_ICMS_ST_MOV MOV_SAI ON  
		CRED.CD_EMP = MOV_SAI.CD_EMP
		AND CRED.CD_FILIAL = MOV_SAI.CD_FILIAL
		AND CRED.CD_NF = MOV_SAI.CD_NF_ENT_CRED
		AND CRED.CD_PROD = MOV_SAI.CD_PROD
		AND MOV_SAI.TIPO_DOC = 2
		AND MOV_SAI.STATUS = 1
		AND ISNULL(MOV_SAI.PROT_ICMS_ST_SAIDA,0 ) =  0
		AND MOV_SAI.STATUS = 1

		AND NOT EXISTS ( SELECT CD_EMP FROM  EST_NF_ENT_ENTRADA_ICMS_ST_MOV MOV_CANCEL
		      WHERE  MOV_CANCEL.CD_EMP = MOV_SAI.CD_EMP 
			  AND MOV_CANCEL.CD_FILIAL = MOV_SAI.CD_FILIAL 
			  AND MOV_CANCEL.CD_NF_ENT_CRED = MOV_SAI.CD_NF_ENT_CRED 
			  AND MOV_CANCEL.CD_PROD = MOV_SAI.CD_PROD
			  AND MOV_CANCEL.PROT_ICMS_ST_SAIDA = MOV_SAI.PROT_ICMS_ST
			  AND MOV_CANCEL.STATUS = 2)
	    		
		LEFT JOIN EST_NF_SAI  SAI ON 
		MOV_SAI.CD_EMP = SAI.CD_EMP 
		AND  MOV_SAI.CD_FILIAL =  SAI.CD_FILIAL 
		AND MOV_SAI.CD_DOC = SAI.CD_NF
		 	 
		WHERE CRED.CD_EMP  =  1 

		--AND CRED.CD_EMP =  1 
		--AND CRED.CD_FILIAL  = 5 
		--AND CRED.CD_NF  =  23
		--AND P.CD_PROD  = 62402


		UNION ALL

		SELECT
		ENT.CD_EMP,
		ENT.CD_FILIAL, 
		ENT.CD_NF AS CD_NF_ENT ,
		ENT.NR_NF AS NR_NF_ENTRADA, 
		ENT.DT_ENT AS DATA_ENTRADA ,
		'NOTA FISCAL ENTRADA DEVOLUCAO' AS TIPO_DOC , 
		CASE WHEN O.TP_MOV = 10 THEN 'ENTRADA TRANSFERNCIA' 
			 WHEN O.TP_MOV = 0 THEN 'ENTRADA COMPRAS'
		ELSE DS.DS_MOV END AS TIPO_ENTRADA ,
		ISNULL(SAI.CD_NF,0) AS CD_NF_SAI ,
		ISNULL(SAI.NF_NF,0) AS NR_DOC,
		0 AS CD_CX, 
		ISNULL(SAI.DT_EMI_NF,'') AS DATA_SAIDA , 
		CRED.CD_PROD,
		P.DS_PROD ,
		ENT_DEV.NR_NF AS NR_NF_DEV,
		ENT_DEV.DT_ENT AS DT_NF_DEV,
		0 AS QT_IT_ENT,
		0 AS VLR_ICMS_ST_DARE_ENT, 
		0 AS  VLR_ICMS_EFETIVO_ENT,
		0 AS VLR_ICMS_SUBS_ENT,
		0 AS  VLR_ICMS_RET_ENT,
		0 AS  VLR_FECOP_ENT,
		0 AS VLR_FECOP_RET_ENT,
		0 AS VLR_FECOP_ST_ENT,

		SAI.NF_NF AS  NOTA_SAI ,
		MOV_DEV.QT_IT  AS QT_IT_SAI ,
		MOV_DEV.VLR_ICMS_ST_DARE *  MOV_DEV.QT_IT  AS VLR_ICMS_ST_DARE_SAI,
		MOV_DEV.VLR_ICMS_EFETIVO *  MOV_DEV.QT_IT AS VLR_ICMS_EFETIVO_SAI,
		MOV_DEV.VLR_ICMS_SUBS * MOV_DEV.QT_IT AS VLR_ICMS_SUBS_SAI,
		MOV_DEV.VLR_ICMS_RET *   MOV_DEV.QT_IT AS VLR_ICMS_RET_SAI, 
		MOV_DEV.VLR_FECOP *  MOV_DEV.QT_IT AS VLR_FECOP_SAI,
		MOV_DEV.VLR_FECOP_RET *  MOV_DEV.QT_IT AS VLR_FECOP_RET_SAI,
		MOV_DEV.VLR_FECOP_ST *  MOV_DEV.QT_IT AS VLR_FECOP_ST_SAI,

		ISNULL(MOV_DEV.PROT_ICMS_ST_SAIDA,0 ) AS PROT_ICMS_ST_SAIDA

		FROM EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS CRED
		 INNER JOIN EST_NF_ENT  ENT ON
		 CRED.CD_EMP = ENT.CD_EMP
		AND CRED.CD_FILIAL = ENT.CD_FILIAL
		AND CRED.CD_NF = ENT.CD_NF
		INNER JOIN GLB_MOV_OP O ON O.CD_MOV_OP = ENT.CD_NT_MOV
		INNER JOIN GLB_MOV_OP_TP_MOV DS ON DS.TP_MOV = O.TP_MOV
		INNER JOIN EST_PROD P ON CRED.CD_EMP = P.CD_EMP 
		AND P.CD_PROD =  CRED.CD_PROD

		INNER JOIN EST_NF_ENT_ENTRADA_ICMS_ST_MOV MOV_DEV ON  
		CRED.CD_EMP = MOV_DEV.CD_EMP
		AND CRED.CD_FILIAL = MOV_DEV.CD_FILIAL
		AND CRED.CD_NF = MOV_DEV.CD_NF_ENT_CRED
		AND CRED.CD_PROD = MOV_DEV.CD_PROD
		AND MOV_DEV.TIPO_DOC = 2
		AND MOV_DEV.STATUS = 3
		AND MOV_DEV.QT_IT < 0
		AND ISNULL(MOV_DEV.PROT_ICMS_ST_SAIDA,0 ) >  0
	    
		LEFT JOIN EST_NF_ENT_IT  IT_DEV ON 
		MOV_DEV.CD_EMP = IT_DEV.CD_EMP 
		AND  MOV_DEV.CD_FILIAL =  IT_DEV.CD_FILIAL 
		AND MOV_DEV.CD_DOC = IT_DEV.CD_NF
		AND MOV_DEV.CD_PROD = IT_DEV.CD_PROD

		LEFT JOIN EST_NF_ENT ENT_DEV ON 
		ENT_DEV.CD_EMP = IT_DEV.CD_EMP 
		AND  ENT_DEV.CD_FILIAL =  IT_DEV.CD_FILIAL 
		AND ENT_DEV.CD_NF = IT_DEV.CD_NF
				
		LEFT JOIN EST_NF_ENT_ENTRADA_ICMS_ST_MOV MOV_SAI_ORIG ON 
		MOV_DEV.CD_EMP = MOV_SAI_ORIG.CD_EMP
		AND MOV_DEV.CD_FILIAL = MOV_SAI_ORIG.CD_FILIAL
		AND MOV_DEV.CD_PROD = MOV_SAI_ORIG.CD_PROD
		AND MOV_DEV.PROT_ICMS_ST_SAIDA = MOV_SAI_ORIG.PROT_ICMS_ST
		AND MOV_DEV.TIPO_DOC = 2

		LEFT JOIN EST_NF_SAI  SAI ON 
		MOV_SAI_ORIG.CD_EMP = SAI.CD_EMP 
		AND  MOV_SAI_ORIG.CD_FILIAL =  SAI.CD_FILIAL 
		AND MOV_SAI_ORIG.CD_DOC = SAI.CD_NF
 
		WHERE CRED.CD_EMP = 1 
	 
		--AND CRED.CD_EMP =  1 
		--AND CRED.CD_FILIAL  = 5 
		--AND CRED.CD_NF  =  23
	 --   AND P.CD_PROD  = 62402


        UNION ALL  -- PDV

		SELECT 
		ENT.CD_EMP,
		ENT.CD_FILIAL, 
		ENT.CD_NF AS CD_NF_ENT ,
		ENT.NR_NF AS NR_NF_ENTRADA, 
		ENT.DT_ENT AS DATA_ENTRADA,
		'VENDA PDV' AS TIPO_DOC , 
		CASE WHEN O.TP_MOV = 10 THEN 'ENTRADA TRANSFERNCIA' 
			 WHEN O.TP_MOV = 0 THEN 'ENTRADA COMPRAS'
		ELSE DS.DS_MOV END AS TIPO_ENTRADA ,
		ISNULL(SAI.CD_VD,0) AS CD_NF_SAI ,
		ISNULL(SAI.NR_ECF,0) AS NR_DOC, 
		SAI.CD_CX AS CD_CX, 
		ISNULL(SAI.DT_VD,'') AS DATA_SAIDA , 
		CRED.CD_PROD,
		P.DS_PROD ,
		0 AS NR_NF_DEV,
		'' AS DT_NF_DEV,
		CRED.QT_IT AS QT_IT_ENT,
		CRED.VLR_ICMS_ST_DARE AS VLR_ICMS_ST_DARE_ENT, 
		CRED.VLR_ICMS_EFETIVO AS  VLR_ICMS_EFETIVO_ENT,
		CRED.VLR_ICMS_SUBS AS VLR_ICMS_SUBS_ENT,
		CRED.VLR_ICMS_RET AS  VLR_ICMS_RET_ENT,
		CRED.VLR_FECOP AS  VLR_FECOP_ENT,
		CRED.VLR_FECOP_RET AS VLR_FECOP_RET_ENT,
		CRED.VLR_FECOP_ST AS VLR_FECOP_ST_ENT,

		SAI.NR_ECF AS  NOTA_SAI ,
		MOV_SAI.QT_IT AS QT_IT_SAI ,
		MOV_SAI.VLR_ICMS_ST_DARE * MOV_SAI.QT_IT AS VLR_ICMS_ST_DARE_SAI,
		MOV_SAI.VLR_ICMS_EFETIVO * MOV_SAI.QT_IT AS VLR_ICMS_EFETIVO_SAI,
		MOV_SAI.VLR_ICMS_SUBS * MOV_SAI.QT_IT AS VLR_ICMS_SUBS_SAI,
		MOV_SAI.VLR_ICMS_RET * MOV_SAI.QT_IT AS VLR_ICMS_RET_SAI, 
		MOV_SAI.VLR_FECOP * MOV_SAI.QT_IT AS VLR_FECOP_SAI,
		MOV_SAI.VLR_FECOP_RET * MOV_SAI.QT_IT AS VLR_FECOP_RET_SAI,
		MOV_SAI.VLR_FECOP_ST * MOV_SAI.QT_IT AS VLR_FECOP_ST_SAI, 

		ISNULL(MOV_SAI.PROT_ICMS_ST_SAIDA,0 ) AS PROT_ICMS_ST_SAIDA
		
		FROM EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS CRED
		 INNER JOIN EST_NF_ENT  ENT ON
		 CRED.CD_EMP = ENT.CD_EMP
		AND CRED.CD_FILIAL = ENT.CD_FILIAL
		AND CRED.CD_NF = ENT.CD_NF
		INNER JOIN GLB_MOV_OP O ON O.CD_MOV_OP = ENT.CD_NT_MOV
		INNER JOIN GLB_MOV_OP_TP_MOV DS ON DS.TP_MOV = O.TP_MOV
		INNER JOIN EST_PROD P ON CRED.CD_EMP = P.CD_EMP 
		AND P.CD_PROD =  CRED.CD_PROD 

		INNER JOIN EST_NF_ENT_ENTRADA_ICMS_ST_MOV MOV_SAI ON  
		CRED.CD_EMP = MOV_SAI.CD_EMP
		AND CRED.CD_FILIAL = MOV_SAI.CD_FILIAL
		AND CRED.CD_NF = MOV_SAI.CD_NF_ENT_CRED
		AND CRED.CD_PROD = MOV_SAI.CD_PROD
		AND MOV_SAI.TIPO_DOC = 0
		AND MOV_SAI.STATUS = 1
		AND ISNULL(MOV_SAI.PROT_ICMS_ST_SAIDA,0 ) =  0

		AND NOT EXISTS ( SELECT CD_EMP FROM  EST_NF_ENT_ENTRADA_ICMS_ST_MOV MOV_CANCEL
		      WHERE  MOV_CANCEL.CD_EMP = MOV_SAI.CD_EMP 
			  AND MOV_CANCEL.CD_FILIAL = MOV_SAI.CD_FILIAL 
			  AND MOV_CANCEL.CD_NF_ENT_CRED = MOV_SAI.CD_NF_ENT_CRED 
			  AND MOV_CANCEL.CD_PROD = MOV_SAI.CD_PROD
			  AND MOV_CANCEL.PROT_ICMS_ST_SAIDA = MOV_SAI.PROT_ICMS_ST
			  AND MOV_CANCEL.STATUS = 2)
 
		LEFT JOIN PDV_VD SAI ON 
		MOV_SAI.CD_EMP = SAI.CD_EMP 
		AND  MOV_SAI.CD_FILIAL =  SAI.CD_FILIAL 
		AND MOV_SAI.CD_DOC = SAI.CD_VD

		WHERE CRED.CD_EMP = 1 
		
		--AND CRED.CD_FILIAL  = 5 
		--AND CRED.CD_NF  =  23
		--AND P.CD_PROD  = 62402
 

		UNION ALL

		SELECT 
		ENT.CD_EMP,
		ENT.CD_FILIAL, 
		ENT.CD_NF AS CD_NF_ENT ,
		ENT.NR_NF AS NR_NF_ENTRADA, 
		ENT.DT_ENT AS DATA_ENTRADA ,
		'NOTA FISCAL ENTRADA DEVOLUCAO' AS TIPO_DOC , 
		CASE WHEN O.TP_MOV = 10 THEN 'ENTRADA TRANSFERNCIA' 
			 WHEN O.TP_MOV = 0 THEN 'ENTRADA COMPRAS'
		ELSE DS.DS_MOV END AS TIPO_ENTRADA ,
		ISNULL(SAI.CD_NF,0) AS CD_NF_SAI ,
		ISNULL(SAI.NR_ECF,0) AS NR_DOC,
		SAI.CD_CX AS CD_CX, 
		ISNULL(SAI.DT_VD,'') AS DATA_SAIDA , 
		CRED.CD_PROD,
		P.DS_PROD ,
		ENT_DEV.NR_NF AS NR_NF_DEV,
		ENT_DEV.DT_ENT AS DT_NF_DEV,
		0 AS QT_IT_ENT,
		0 AS VLR_ICMS_ST_DARE_ENT, 
		0 AS  VLR_ICMS_EFETIVO_ENT,
		0 AS VLR_ICMS_SUBS_ENT,
		0 AS  VLR_ICMS_RET_ENT,
		0 AS  VLR_FECOP_ENT,
		0 AS VLR_FECOP_RET_ENT,
		0 AS VLR_FECOP_ST_ENT,

		SAI.NR_ECF AS  NOTA_SAI ,
		MOV_DEV.QT_IT   AS QT_IT_SAI ,
		MOV_DEV.VLR_ICMS_ST_DARE *  MOV_DEV.QT_IT  AS VLR_ICMS_ST_DARE_SAI,
		MOV_DEV.VLR_ICMS_EFETIVO *  MOV_DEV.QT_IT AS VLR_ICMS_EFETIVO_SAI,
		MOV_DEV.VLR_ICMS_SUBS *  MOV_DEV.QT_IT AS VLR_ICMS_SUBS_SAI,
		MOV_DEV.VLR_ICMS_RET *   MOV_DEV.QT_IT AS VLR_ICMS_RET_SAI, 
		MOV_DEV.VLR_FECOP *  MOV_DEV.QT_IT AS VLR_FECOP_SAI,
		MOV_DEV.VLR_FECOP_RET *  MOV_DEV.QT_IT AS VLR_FECOP_RET_SAI,
		MOV_DEV.VLR_FECOP_ST *  MOV_DEV.QT_IT AS VLR_FECOP_ST_SAI,

		ISNULL(MOV_DEV.PROT_ICMS_ST_SAIDA,0 ) AS PROT_ICMS_ST_SAIDA

		FROM EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS CRED
		 INNER JOIN EST_NF_ENT  ENT ON
		 CRED.CD_EMP = ENT.CD_EMP
		AND CRED.CD_FILIAL = ENT.CD_FILIAL
		AND CRED.CD_NF = ENT.CD_NF
		INNER JOIN GLB_MOV_OP O ON O.CD_MOV_OP = ENT.CD_NT_MOV
		INNER JOIN GLB_MOV_OP_TP_MOV DS ON DS.TP_MOV = O.TP_MOV
		INNER JOIN EST_PROD P ON CRED.CD_EMP = P.CD_EMP 
		AND P.CD_PROD =  CRED.CD_PROD

		INNER JOIN EST_NF_ENT_ENTRADA_ICMS_ST_MOV MOV_DEV ON  
		CRED.CD_EMP = MOV_DEV.CD_EMP
		AND CRED.CD_FILIAL = MOV_DEV.CD_FILIAL
		AND CRED.CD_NF = MOV_DEV.CD_NF_ENT_CRED
		AND CRED.CD_PROD = MOV_DEV.CD_PROD
		AND MOV_DEV.TIPO_DOC = 0
		AND MOV_DEV.STATUS = 3
		AND MOV_DEV.QT_IT < 0
		AND ISNULL(MOV_DEV.PROT_ICMS_ST_SAIDA,0 ) >  0
	    
		LEFT JOIN EST_NF_ENT_IT  IT_DEV ON 
		MOV_DEV.CD_EMP = IT_DEV.CD_EMP 
		AND  MOV_DEV.CD_FILIAL =  IT_DEV.CD_FILIAL 
		AND MOV_DEV.CD_DOC = IT_DEV.CD_NF
		AND MOV_DEV.CD_PROD = IT_DEV.CD_PROD

		LEFT JOIN EST_NF_ENT ENT_DEV ON 
		ENT_DEV.CD_EMP = IT_DEV.CD_EMP 
		AND  ENT_DEV.CD_FILIAL =  IT_DEV.CD_FILIAL 
		AND ENT_DEV.CD_NF = IT_DEV.CD_NF
				
		LEFT JOIN EST_NF_ENT_ENTRADA_ICMS_ST_MOV MOV_SAI_ORIG ON 
		MOV_DEV.CD_EMP = MOV_SAI_ORIG.CD_EMP
		AND MOV_DEV.CD_FILIAL = MOV_SAI_ORIG.CD_FILIAL
		AND MOV_DEV.CD_PROD = MOV_SAI_ORIG.CD_PROD
		AND MOV_DEV.PROT_ICMS_ST_SAIDA = MOV_SAI_ORIG.PROT_ICMS_ST
		AND MOV_DEV.TIPO_DOC = 0

		LEFT JOIN PDV_VD SAI ON 
		MOV_SAI_ORIG.CD_EMP = SAI.CD_EMP 
		AND  MOV_SAI_ORIG.CD_FILIAL =  SAI.CD_FILIAL 
		AND MOV_SAI_ORIG.CD_DOC = SAI.CD_VD
 
		WHERE CRED.CD_EMP = 1 
  
) RS_TEMP
WHERE RS_TEMP.CD_FILIAL IN (SELECT DISTINCT ITEM
							FROM dbo.UFD_STRING_SPLIT(@CD_FILIAL, ','))
	AND RS_TEMP.CD_EMP = @CD_EMP
	AND ((CONVERT(DATE,RS_TEMP.DATA_ENTRADA) BETWEEN @DT_INICIO AND @DT_FIM AND @TIPO_DATA = 0)
			OR
		(CONVERT(DATE,RS_TEMP.DATA_SAIDA) BETWEEN @DT_INICIO AND @DT_FIM AND @TIPO_DATA = 1))

	
END